/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.collect.Lists;
import cz.insophy.inplan.util.Comparators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;

public class Tuple<T1, T2>
implements Serializable {
    private static final long serialVersionUID = -9178273539211284436L;
    private final T1 first;
    private final T2 second;

    public Tuple(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public static <T1, T2> Tuple<T1, T2> create(T1 first, T2 second) {
        return new Tuple<T1, T2>(first, second);
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.first, tuple.first) && Objects.equals(this.second, tuple.second);
    }

    private static <A extends Comparable<A>, B extends Comparable<B>> Comparator<Tuple<A, B>> lexicographicComparator(boolean flipped) {
        ArrayList comparators = Lists.newArrayListWithCapacity(2);
        comparators.add(new Comparator<Tuple<A, B>>(){

            @Override
            public int compare(Tuple<A, B> o1, Tuple<A, B> o2) {
                return ((Comparable)o1.getFirst()).compareTo((Comparable)o2.getFirst());
            }
        });
        comparators.add(new Comparator<Tuple<A, B>>(){

            @Override
            public int compare(Tuple<A, B> o1, Tuple<A, B> o2) {
                return ((Comparable)o1.getSecond()).compareTo((Comparable)o2.getSecond());
            }
        });
        if (flipped) {
            Collections.reverse(comparators);
        }
        return Comparators.getJointComparator(comparators);
    }

    public static <A extends Comparable<A>, B extends Comparable<B>> Comparator<Tuple<A, B>> firstSecondLexicographicComparator() {
        return Tuple.lexicographicComparator(false);
    }

    public static <A extends Comparable<A>, B extends Comparable<B>> Comparator<Tuple<A, B>> secondFirstLexicographicComparator() {
        return Tuple.lexicographicComparator(true);
    }

    public static <T1 extends Comparable<T1>, T2 extends Comparable<T2>> Comparator<Tuple<T1, T2>> naturalComparator() {
        return new NaturalComparator();
    }

    private static class NaturalComparator<T1 extends Comparable<T1>, T2 extends Comparable<T2>>
    implements Comparator<Tuple<T1, T2>> {
        private NaturalComparator() {
        }

        @Override
        public int compare(Tuple<T1, T2> o1, Tuple<T1, T2> o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int cmp = Comparators.compareNullsLast((Comparable)o1.getFirst(), (Comparable)o2.getFirst());
            if (cmp == 0) {
                cmp = Comparators.compareNullsLast((Comparable)o1.getSecond(), (Comparable)o2.getSecond());
            }
            return cmp;
        }
    }
}

